#!/c/Perl/bin//perl -w
#
# $Id: mecab-3.pl.in,v 1.1.2.3 2006/01/14 08:42:05 opengl2772 Exp $
# Copyright (C) 2005-2006 Tadamasa Teranishi
#               2005-2006 Namazu Project All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either versions 2, or (at your option)
#  any later version.
#
#  This program is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#  02111-1307, USA
#
#  This file must be encoded in EUC-JP encoding
#
#

#
# Check whether idx111 and idx112 indices are same.
#
# idx111: mecab
# idx112: module_mecab
#

use strict;
require Cwd;
use File::Compare;
use File::Basename;
require 'pltests.pl';

my $cwd = Cwd::cwd();
my $LOG = "$cwd/test-log";
my $INDEX = "$cwd/idx111";
my $INDEX2 = "$cwd/idx112";

pltests::putline($LOG, "  *** starting $0");

if (pltests::get_lang() !~ /^ja/) {
    pltests::putline($LOG, "Skipping because of LANG does not begin with ja: $0");
    exit 77;
}

my @targets = ();
for my $file (<$INDEX/NMZ.*>) {
    if ($file !~ /NMZ\.(?:log|r|slog|status|err)$/s) {
        push @targets, basename($file);
    }
}

my @targets2 = ();
for my $file (<$INDEX2/NMZ.*>) {
    if ($file !~ /NMZ\.(?:log|r|slog|status|err)$/s) {
        push @targets2, basename($file);
    }
}

if ($#targets == -1 || $#targets2 == -1) {
    exit 77;
}

my $stat = 0;
for my $file (@targets) {
    if (compare("$INDEX/$file", "$INDEX2/$file") != 0) {
        pltests::putline($LOG, "diff $INDEX/$file $INDEX2/$file");
        $stat = 1;
    }
}

exit $stat;
